#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_VbecsDateTime : BaseTest 
	{

		
		private DataTable _dtTimeZone;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtTimeZone = UnitTestUtil.RunSQLGetDataTable("SELECT TZ.* FROM VamcDivision D JOIN TimeZone TZ ON D.TimeZoneID = TZ.TimeZoneID WHERE D.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetDivisionTimeZone_Pass()
		{
			string timeZone = this._dtTimeZone.Rows[0][Common.VbecsTables.TimeZone.TimeZoneName].ToString();
			string daylight = this._dtTimeZone.Rows[0].IsNull(Common.VbecsTables.TimeZone.DaylightTimeName) ? timeZone : this._dtTimeZone.Rows[0][Common.VbecsTables.TimeZone.DaylightTimeName].ToString();

			string zoneTest = DAL.VbecsDateTime.GetDivisionTimeZone();
			
			//Check for Daylight TimeZone too
			Assert.AreEqual(true, timeZone == zoneTest || zoneTest == daylight, "TimeZone compare" );
		}

		[Test]
		public void GetDivisionTimeZone_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXXXX";

			string tstExpected = "Time Zone is not setup for division " + Common.LogonUser.LogonUserDivisionCode;

			string tstActual = DAL.VbecsDateTime.GetDivisionTimeZone();

			Assert.AreEqual(tstExpected, tstActual);
		}
		

		[Test]
		public void GetDivisionTimeZoneAbbreviation_Pass()
		{
			string tstValue = DAL.VbecsDateTime.GetDivisionTimeZoneAbbreviation();

			Assert.AreEqual(tstValue, tstValue, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDivisionTimeZoneAbbreviation_Fail()
		{
		}

		[Test]
		public void GetDivisionCurrentDateTime_Blank_Pass()
		{
			System.DateTime tst1 = DAL.VbecsDateTime.GetDivisionCurrentDateTime();
			System.DateTime tst2 = DAL.VbecsDateTime.GetDivisionCurrentDateTime(Common.LogonUser.LogonUserDivisionCode);

			Assert.AreEqual(true, tst2 >= tst1, "Time compares are tricky");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDivisionCurrentDateTime_Blank_Fail()
		{
		}

		[Test]
		public void GetDivisionCurrentDateTime_Division_Pass()
		{
			System.DateTime dateTest = DAL.VbecsDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode);
			System.DateTime lowRange = System.DateTime.Now.AddDays(-1);		//Any time zone should never be greater than 1 day away..
			System.DateTime hiRange = System.DateTime.Now.AddDays(1);		//or so my public school education has taught me

			Assert.AreEqual(true, dateTest >= lowRange, "Lo test value");
			Assert.AreEqual(true, dateTest <= hiRange, "Hi test value");
		}

		[Test]
		public void GetDivisionCurrentDateTime_Division_Fail()
		{
			//Failure = System.DateTime.Now -- So we allow for +/- 2 seconds
			System.DateTime dateTest = DAL.VbecsDateTime.GetDivisionCurrentDateTime("XXXXX");
			System.DateTime lowRange = System.DateTime.Now.AddSeconds(-2);
			System.DateTime hiRange = System.DateTime.Now;

			Assert.AreEqual(true, dateTest >= lowRange,  "Lo test value");
			Assert.AreEqual(true, dateTest <= hiRange, "Hi test value");
		}



	}
}
#endif
